#include <iostream>
#include <string>
#include <vector>
#include <algorithm>
#include <set>
#include <array>
#include <numeric>

using namespace std;

using ll = long long;

const ll MOD = 1e9 + 7;

ll brute(vector<int> b)
{
    int n = b.size();
    vector<int> p(n);
    iota(p.begin(), p.end(), 1);
    ll res = 0;
    do
    {
        ++res;
        for (int i = 0; i < n; ++i)
        {
            set<int> pool;
            if (i > 0) pool.insert(p[i - 1]);
            if (i + 1 < n) pool.insert(p[i + 1]);
            pool.insert(p[i]);
            if (pool.find(b[i]) == pool.end())
            {
                --res;
                break;
            }
        }
    } while (next_permutation(p.begin(), p.end()));
    return res;
}

int main()
{
    cin.tie(0)->sync_with_stdio(0);
    int n;
    cin >> n;
    vector<int> b(n);
    for (int &i : b) cin >> i;
    //cout << brute(b) << '\n';
    vector<vector<int>> inds(n + 1);
    for (int i = 0; i < n; ++i) inds[b[i]].push_back(i);
    for (int i = 1; i <= n; ++i)
    {
        if (inds[i].size() > 1)
        {
            if (inds[i].back() - inds[i].front() > 2)
            {
                cout << 0;
                return 0;
            }
        }
    }
    int left = n - (int)set<int>(b.begin(), b.end()).size();
    ll res = 1;
    for (ll i = 1; i <= left; ++i) res = (res * i) % MOD;
    vector<vector<int>> good(n + 1);
    vector<int> nums;
    for (int i = 1; i <= n; ++i)
    {
        if (inds[i].empty()) continue;
        nums.push_back(i);
        if (inds[i].size() == 1)
        {
            if (inds[i][0] - 1 >= 0) good[i].push_back(inds[i][0] - 1);
            good[i].push_back(inds[i][0]);
            if (inds[i][0] + 1 < n) good[i].push_back(inds[i][0] + 1);
        }
        else if (inds[i].size() == 2)
        {
            if (inds[i].back() - inds[i].front() == 2)
            {
                good[i].push_back(inds[i].back() - 1);
            }
            else
            {
                good[i].push_back(inds[i][0]);
                good[i].push_back(inds[i][1]);
            }
        }
        else
        {
            good[i].push_back(inds[i][1]);
        }
    }
    sort(nums.begin(), nums.end(), [&good](int a, int b){ return good[a].back() < good[b].back(); });
    vector<array<ll, 8>> dp(n + 1);
    for (int i = 0; i <= n; ++i) dp[i].fill(0);
    dp[0][0] = 1;
    for (int i = 0, j = 0; i < n; ++i)
    {
        if (j != nums.size() && good[nums[j]].back() < i) ++j;
        if (j == nums.size() || good[nums[j]].back() > i)
        {
            for (int mask = 0; mask < 8; ++mask)
            {
                int nmask = mask >> 1;
                dp[i + 1][nmask] += dp[i][mask];
                if (dp[i + 1][nmask] >= MOD) dp[i + 1][nmask] -= MOD;
            }
        }
        else
        {
            for (int mask = 0; mask < 8; ++mask)
            {
                for (int k : good[nums[j]])
                {
                    if (k == i)
                    {
                        int nmask = mask >> 1;
                        nmask ^= 4;
                        dp[i + 1][nmask] += dp[i][mask];
                        if (dp[i + 1][nmask] >= MOD) dp[i + 1][nmask] -= MOD;
                    }
                    else
                    {
                        if (mask & (1 << (3 - i + k))) continue;
                        int nmask = mask ^ (1 << (3 - i + k));
                        nmask >>= 1;
                        dp[i + 1][nmask] += dp[i][mask];
                        if (dp[i + 1][nmask] >= MOD) dp[i + 1][nmask] -= MOD;
                    }
                }
            }
            ++j;
            if (j != nums.size() && good[nums[j]].back() == i)
            {
                array<ll, 8> ndp{};
                for (int mask = 0; mask < 8; ++mask)
                {
                    for (int k : good[nums[j]])
                    {
                        if (mask & (1 << (2 - i + k))) continue;
                        int nmask = mask ^ (1 << (2 - i + k));
                        ndp[nmask] += dp[i + 1][mask];
                        if (ndp[nmask] >= MOD) ndp[nmask] -= MOD;
                    }
                }
                dp[i + 1] = ndp;
            }
        }
    }
    ll sum = 0;
    for (int i = 0; i < 8; ++i) sum += dp.back()[i];
    sum %= MOD;
    cout << res * sum % MOD;
    return 0;
}
//0110
//0 1 0 2 0
//0 1 0 0 2
//1 2 3 +
//1 3 2 +
//2 1 3 +
//2 3 1 -
//3 1 2 -
//3 2 1 -
